﻿Create Database Project_new
go
USE Project_new
GO

-- Danh mục sản phẩm
CREATE TABLE DanhMuc(
    MaDM INT IDENTITY(1,1) PRIMARY KEY,
    TenDM NVARCHAR(100),
    AnhDM NVARCHAR(MAX)
)
GO

-- Loại sản phẩm 
CREATE TABLE LoaiSanPham(
    MaLSP INT IDENTITY(1,1) PRIMARY KEY,
    MaDM INT FOREIGN KEY REFERENCES DanhMuc(MaDM),
    TenLSP NVARCHAR(100)
)
GO

-- Nhà cung cấp nguyên liệu 
CREATE TABLE HangSanXuat(
    MaHSX INT IDENTITY(1,1) PRIMARY KEY,
    TenHSX NVARCHAR(100),
    SdtHSX VARCHAR(20),
    EmailHSX VARCHAR(50),
    DiaChiHSX NVARCHAR(MAX),
    AnhHSX NVARCHAR(MAX)
)
GO

-- Sản phẩm 
CREATE TABLE SanPham(
    MaSP VARCHAR(50) PRIMARY KEY,
    MaHSX INT FOREIGN KEY REFERENCES HangSanXuat(MaHSX),
    MaLSP INT FOREIGN KEY REFERENCES LoaiSanPham(MaLSP),
    TenSP NVARCHAR(200),
    SizeSP VARCHAR(10),
    GiaSP varchar(20),
    GiamGiaSP INT,
    AnhSP NVARCHAR(MAX),
    CapNhatNgayThangSP VARCHAR(50),
    MieuTaSP NVARCHAR(MAX)
)

GO
CREATE TABLE NguyenLieu (
    MaNL INT IDENTITY(1,1) PRIMARY KEY,
    TenNL NVARCHAR(100) NOT NULL,
    DonViTinh VARCHAR(20) NOT NULL, -- gram, ml, kg, lon...
    SoLuongTon DECIMAL(10, 2) DEFAULT 0,
    DonGia DECIMAL(12, 2),
    HanSuDung VARCHAR(100),
    NhaCungCap NVARCHAR(100),
    MoTa NVARCHAR(200)
)

GO
CREATE TABLE CongThuc (
    MaSP VARCHAR(50) FOREIGN KEY REFERENCES SanPham(MaSP),
    MaNL INT FOREIGN KEY REFERENCES NguyenLieu(MaNL),
    SoLuongCanDung DECIMAL(10, 2) NOT NULL,
    GhiChu NVARCHAR(200),
    PRIMARY KEY (MaSP, MaNL)
)

GO
CREATE TABLE NhapHang (
    MaPhieuNhap INT IDENTITY(1,1) PRIMARY KEY,
    NgayNhapHang DATETIME2,
    NhaCungCap NVARCHAR(100),
    TongTien DECIMAL(12, 2),
    GhiChu NVARCHAR(MAX)
)

GO
CREATE TABLE ChiTietNhapHang (
    MaPhieuNhap INT FOREIGN KEY REFERENCES NhapHang(MaPhieuNhap),
    MaNL INT FOREIGN KEY REFERENCES NguyenLieu(MaNL),
    SoLuong DECIMAL(10, 2) NOT NULL,
    DonGia DECIMAL(12, 2) NOT NULL,
    ThanhTien AS (SoLuong * DonGia),
    PRIMARY KEY (MaPhieuNhap, MaNL)
)

GO
-- Quản lý hệ thống quán cà phê
CREATE TABLE QuanLy(
    TkQL VARCHAR(500) PRIMARY KEY,
    MkQL VARCHAR(500),
    HoTenQL NVARCHAR(200),
    SdtQL VARCHAR(200)
)
GO

-- Khách hàng
CREATE TABLE KhachHang(
    SdtKH VARCHAR(20) PRIMARY KEY,
    HoTenKH NVARCHAR(200),
    EmailKH VARCHAR(100),
    DiaChiKH NVARCHAR(500),
    PassKH VARCHAR(500) NULL
)
GO

-- Đơn đặt hàng 
CREATE TABLE DonDatHang(
    MaDDH VARCHAR(20) PRIMARY KEY,
    SdtKH VARCHAR(20) FOREIGN KEY REFERENCES KhachHang(SdtKH),
    TinNhanDDH NVARCHAR(MAX),
    NgayGioDDH varchar(50),
    TrangThaiDDH Nvarchar(50)
)
GO

-- Chi tiết đơn đặt hàng
CREATE TABLE DonDatHangChiTiet(
    MaDDHCT INT IDENTITY(1,1) PRIMARY KEY,
    MaDDH VARCHAR(20) FOREIGN KEY REFERENCES DonDatHang(MaDDH),
    MaSP VARCHAR(50) FOREIGN KEY REFERENCES SanPham(MaSP),
    SoLuongDDHCT INT,
    ThanhTienDDHCT varchar(50)
)
GO

-- Đánh giá món 
CREATE TABLE TiLe(
    MaSP VARCHAR(50) FOREIGN KEY REFERENCES SanPham(MaSP),
    TiLeSao INT,
    CONSTRAINT PK_Gia PRIMARY KEY (MaSP)
)
GO

-- Bình luận về món 
CREATE TABLE BinhLuan(
    MaBinhLuan INT IDENTITY(1,1) PRIMARY KEY,
    MaSP VARCHAR(50) FOREIGN KEY REFERENCES SanPham(MaSP),
    TinNhanBinhLuan NVARCHAR(MAX)
)
GO
	--Insert table QuanLy
	Insert into QuanLy values('a@gmail.com','123',N'Nguyễn Văn A', '0999999999')
	Insert into QuanLy values('b@gmail.com','345',N'Nguyễn Văn B', '0999999998')
	Insert into QuanLy values('c@gmail.com','456',N'Nguyễn Văn C', '0999999997')
	Insert into QuanLy values('d@gmail.com','789',N'Nguyễn Văn D', '0999999996')


    -- Insert table DanhMuc
    INSERT INTO DanhMuc VALUES(N'Cà phê', N'/Image/ca_phe.png') 
    INSERT INTO DanhMuc VALUES(N'Trà', N'/Image/tra.png') 
    INSERT INTO DanhMuc VALUES(N'Đồ uống khác', N'/Image/do_uong_khac.png') 
    INSERT INTO DanhMuc VALUES(N'Bánh', N'/Image/banh_ngot.png') 
     

    -- Insert table LoaiSanPham
    -- Cà phê
    INSERT INTO LoaiSanPham VALUES(1, N'Cà phê truyền thống') 
    INSERT INTO LoaiSanPham VALUES(1, N'Cà phê đặc biệt') 
    -- Trà
    INSERT INTO LoaiSanPham VALUES(2, N'Trà trái cây') 
    INSERT INTO LoaiSanPham VALUES(2, N'Trà sữa') 
    INSERT INTO LoaiSanPham VALUES(2, N'Trà thảo mộc') 
    -- Đồ uống khác
    INSERT INTO LoaiSanPham VALUES(3, N'Nước ép') 
    INSERT INTO LoaiSanPham VALUES(3, N'Sinh tố') 
    INSERT INTO LoaiSanPham VALUES(3, N'Soda') 
    -- Bánh ngọt
    INSERT INTO LoaiSanPham VALUES(4, N'Bánh ngọt') 


    -- Insert table HangSanXuat (Nhà cung cấp)
    INSERT INTO HangSanXuat VALUES(N'Hoàng Tuấn Coffee','0999999999','hoangtuancoffee@gmail.com',N'TP.HCM',N'/Image/hoang_tuan.jpg'); 


    -- Insert table SanPham
    -- Insert table SanPham
        -- cà phê đặc biệt 
    INSERT INTO SanPham VALUES('CF001', 1, 2, N'Cà Phê Robusta', 'M, L', 35000, 0, N'/Image/ca_phe_robusta.png', '01/01/2025 6:00:06 AM', N'Cà phê Robusta đậm đà nguyên chất')
    INSERT INTO SanPham VALUES('CF002', 1, 2, N'Cà Phê Thơm Đậm', 'M, L', 40000, 5, N'/Image/ca_phe_thom_dam.png', '01/01/2025 6:00:06 AM', N'Cà phê hương thơm đậm đặc trưng')
    INSERT INTO SanPham VALUES('CF003', 1, 2, N'Cà Phê Xúc Tác', 'M, L', 45000, 0, N'/Image/ca_phe_xuc_tac.png', '01/01/2025 6:00:06 AM', N'Cà phê pha chế đặc biệt')
    INSERT INTO SanPham VALUES('CF004', 1, 2, N'Cà Phê Thượng Hạng', 'M, L', 50000, 10, N'/Image/ca_phe_thuong_hang.png', '01/01/2025 6:00:06 AM', N'Cà phê hạt cao cấp')
    -- Cà phê truyền thống 
    INSERT INTO SanPham VALUES('CF005', 1, 1, N'Bạc xỉu', 'M, L', 30000, 0, N'/Image/bac_xiu.png', '01/01/2025 6:00:06 AM', N'Bạc xỉu ')
    INSERT INTO SanPham VALUES('CF006', 1, 1, N'Cà phê đen', 'M, L', 25000, 0, N'/Image/ca_phe_den.png', '01/01/2025 6:00:06 AM', N'Cà phê đen nguyên chất')
    INSERT INTO SanPham VALUES('CF007', 1, 1, N'Cà phê Sữa', 'M, L', 30000, 0, N'/Image/ca_phe_sua.png', '01/01/2025 6:00:06 AM', N'Cà phê sữa đậm đà')
    -- Trà trái cây 
    INSERT INTO SanPham VALUES('TR001', 1, 3, N'Trà Đào', 'M, L', 40000, 0, N'/Image/tra_dao.png', '01/01/2025 6:00:06 AM', N'Trà đào tươi mát')
    INSERT INTO SanPham VALUES('TR002', 1, 3, N'Trà Vải', 'M, L', 40000, 5, N'/Image/tra_vai.png', '01/01/2025 6:00:06 AM', N'Trà vải thanh mát')
    INSERT INTO SanPham VALUES('TR003', 1, 3, N'Trà Dưa Lưới', 'M, L', 45000, 0, N'/Image/tra_dua_luoi.png', '01/01/2025 6:00:06 AM', N'Trà dưa lưới thơm ngon')
    INSERT INTO SanPham VALUES('TR004', 1, 3, N'Trà Đào Cam Sả', 'M, L', 45000, 7, N'/Image/tra_dao_cam_sa.png', '01/01/2025 6:00:06 AM', N'Trà đào kết hợp cam sả')
    INSERT INTO SanPham VALUES('TR005', 1, 3, N'Trà Chôm Chôm', 'M, L', 45000, 5, N'/Image/tra_chom_chom.png', '01/01/2025 6:00:06 AM', N'Trà chôm chôm nhiệt đới')
    INSERT INTO SanPham VALUES('TR006', 1, 3, N'Trà Chanh Dây', 'M, L', 40000, 0, N'/Image/tra_chanh_day.png', '01/01/2025 6:00:06 AM', N'Trà chanh dây chua ngọt')
    INSERT INTO SanPham VALUES('TR007', 1, 3, N'Trà Kỹ Tử Táo Đỏ', 'M, L', 45000, 2, N'/Image/tra_ky_tu_tao_do.png', '01/01/2025 6:00:06 AM', N'Trà kỷ tử táo đỏ')
    -- Trà sữa 
    INSERT INTO SanPham VALUES('TR008', 1, 4, N'Trà sữa Khúc Bạch', 'M, L', 50000, 0, N'/Image/tra_sua_khuc_bach.png', '01/01/2025 6:00:06 AM', N'Trà sữa với khúc bạch')
    INSERT INTO SanPham VALUES('TR009', 1, 4, N'Trà Sữa Hạt Sen', 'M, L', 55000, 5, N'/Image/tra_sua_hat_sen.png', '01/01/2025 6:00:06 AM', N'Trà sữa với hạt sen bổ dưỡng')
    INSERT INTO SanPham VALUES('TR010', 1, 4, N'Trà Sữa Trân Châu Đường Đen', 'M, L', 50000, 0, N'/Image/tra_sua_tran_chau_duong_den.png', '01/01/2025 6:00:06 AM', N'Trà sữa trân châu truyền thống')
    INSERT INTO SanPham VALUES('TR011', 1, 4, N'Trà Sữa Khoai Môn Đậu Đỏ', 'M, L', 55000, 0, N'/Image/tra_sua_khoai_mon_dau_do.png', '01/01/2025 6:00:06 AM', N'Trà sữa khoai môn kết hợp đậu đỏ')
    INSERT INTO SanPham VALUES('TR012', 1, 4, N'Trà Oloong Phômai', 'M, L', 60000, 0, N'/Image/tra_oolong_phomai.png', '01/01/2025 6:00:06 AM', N'Trà oloong với lớp phômai')
    -- Trà thảo mộc 
    INSERT INTO SanPham VALUES('TR013', 1, 5, N'Trà La Hán Quả Cam', 'M, L', 45000, 0, N'/Image/tra_la_han_qua_cam.png', '01/01/2025 6:00:06 AM', N'Trà la hán quả kết hợp cam')
    INSERT INTO SanPham VALUES('TR014', 1, 5, N'Trà Lài Đác Thơm', 'M, L', 40000, 0, N'/Image/tra_lai_dac_thom.png', '01/01/2025 6:00:06 AM', N'Trà lài với đác và thơm')
    -- Nước ép 
    INSERT INTO SanPham VALUES('DU001', 1, 6, N'Táo Ép', 'M, L', 50000, 0, N'/Image/tao_ep.png', '01/01/2025 6:00:06 AM', N'Nước ép táo tươi nguyên chất')
    INSERT INTO SanPham VALUES('DU002', 1, 6, N'Nước Ép Dưa Hấu', 'M, L', 40000, 10, N'/Image/dua_hau_ep.png', '01/01/2025 6:00:06 AM', N'Nước ép dưa hấu mát lạnh')
    INSERT INTO SanPham VALUES('DU003', 1, 6, N'Nước Ép Cà Rốt', 'M, L', 45000, 0, N'/Image/ca_rot_ep.png', '01/01/2025 6:00:06 AM', N'Nước ép cà rốt tốt cho sức khỏe')
    INSERT INTO SanPham VALUES('DU004', 1, 6, N'Nước Ép Cam', 'M, L', 50000, 5, N'/Image/cam_ep.png', '01/01/2025 6:00:06 AM', N'Nước ép cam tươi nguyên chất')
    INSERT INTO SanPham VALUES('DU005', 1, 6, N'Nước Ép Ổi', 'M, L', 45000, 0, N'/Image/oi_ep.png', '01/01/2025 6:00:06 AM', N'Nước ép ổi thơm ngon')
    INSERT INTO SanPham VALUES('DU006', 1, 6, N'Nước Ép Thơm', 'M, L', 40000, 0, N'/Image/thom_ep.png', '01/01/2025 6:00:06 AM', N'Nước ép thơm (dứa)')
    -- Sinh tố 
    INSERT INTO SanPham VALUES('DU007', 1, 7, N'Sinh Tố Dâu', 'M, L', 55000, 0, N'/Image/sinh_to_dau.png', '01/01/2025 6:00:06 AM', N'Sinh tố dâu tươi ngon')
    INSERT INTO SanPham VALUES('DU008', 1, 7, N'Sinh Tố Việt Quốc', 'M, L', 60000, 0, N'/Image/sinh_to_viet_quoc.png', '01/01/2025 6:00:06 AM', N'Sinh tố việt quất bổ dưỡng')
    INSERT INTO SanPham VALUES('DU009', 1, 7, N'Sinh Tố Chanh Dây', 'M, L', 50000, 0, N'/Image/sinh_to_chanh_day.png', '01/01/2025 6:00:06 AM', N'Sinh tố chanh dây ')
    INSERT INTO SanPham VALUES('DU010', 1, 7, N'Sinh Tố Bơ Dằm Hạt Đác', 'M, L', 60000, 5, N'/Image/sinh_to_bo_dam_hat_dac.png', '01/01/2025 6:00:06 AM', N'Sinh tố bơ với hạt đác ')
    INSERT INTO SanPham VALUES('DU011', 1, 7, N'Sinh Tố Xoài', 'M, L', 50000, 0, N'/Image/sinh_to_xoai.png', '01/01/2025 6:00:06 AM', N'Sinh tố xoài nhiệt đới')
    INSERT INTO SanPham VALUES('DU012', 1, 7, N'Sinh Tố Bơ', 'M, L', 55000, 0, N'/Image/sinh_to_bo.png', '01/01/2025 6:00:06 AM', N'Sinh tố bơ')
    -- Soda
    INSERT INTO SanPham VALUES('DU013', 1, 8, N'Nước Đá Chanh', 'M, L', 25000, 0, N'/Image/nuoc_da_chanh.png', '01/01/2025 6:00:06 AM', N'Nước chanh mát lạnh')
    -- Bánh ngọt
    INSERT INTO SanPham VALUES('BN001', 1, 9, N'Bánh quy sô cô la', 'M, L', 35000, 0, N'/Image/banh_quy_so_co_la.png', '01/01/2025 6:00:06 AM', N'Bánh quy sô cô la thơm ngon')



    --Thêm nguyên liệu
    INSERT INTO NguyenLieu (TenNL, DonViTinh, SoLuongTon, DonGia, HanSuDung, NhaCungCap, MoTa)
    VALUES
    (N'Cà phê Arabica', 'gram', 5000.75, 65000.50, '2025-12-31', N'Nhà cung cấp A', N'Cà phê hạt Arabica rang'),
    (N'Sữa tươi', 'ml', 10000.00, 28000.00, '2025-04-15', N'Nhà cung cấp B', N'Sữa tươi'),
    (N'Đường', 'gram', 25000.25, 18000.00, '2026-04-15', N'Nhà cung cấp C', N'Đường tinh luyện'),
    (N'Trà xanh', 'gram', 3000.00, 55000.75, '2025-11-20', N'Nhà cung cấp D', N'Trà xanh Thái Nguyên'),
    (N'Đá viên', 'kg', 50.00, 2000.00, '2025-04-15', N'Nhà cung cấp E', N'Đá viên sạch');



    INSERT INTO CongThuc (MaSP, MaNL, SoLuongCanDung, GhiChu)
    VALUES
    ('CF001', 1, 18.50, N'18.5 gram cà phê cho một ly'),
    ('CF001', 2, 120.00, N'120ml sữa tươi'),
    ('CF007', 1, 15.00, N'15 gram cà phê'),
    ('CF007', 2, 100.00, N'100ml sữa tươi'),
    ('TR001', 4, 12.00, N'12 gram trà xanh');



    INSERT INTO NhapHang (NgayNhapHang, NhaCungCap, TongTien, GhiChu)
    VALUES
    ('2025-04-02 09:00:00', N'Nhà cung cấp A', 325025.00, N'Nhập cà phê Arabica'),
    ('2025-04-01 14:30:00', N'Nhà cung cấp B', 280000.00, N'Nhập sữa tươi'),
    ('2025-03-30 11:15:00', N'Nhà cung cấp C', 450000.50, N'Nhập đường số lượng lớn');


    INSERT INTO ChiTietNhapHang (MaPhieuNhap, MaNL, SoLuong, DonGia)
    VALUES
    (1, 1, 5.00, 65000.50), -- 5 kg cà phê Arabica
    (2, 2, 10.00, 28000.00), -- 10 lít sữa tươi
    (3, 3, 25.00, 18000.02), -- 25 kg đường kính
    (3, 5, 100.00, 2000.00); -- 100 kg đá viên


    --Insert table KhachHang
    INSERT INTO KhachHang VALUES('0901111111', N'Nguyễn Văn An', 'an@gmail.com', N'123 Đường A, TP.HCM','123456')
    INSERT INTO KhachHang VALUES('0901111112', N'Trần Thị Bình', 'binh@gmail.com', N'124 Đường B, TP.HCM','123456')
    INSERT INTO KhachHang VALUES('0901111113', N'Lê Văn Cường', 'cuong@gmail.com', N'125 Đường C, TP.HCM','123456')
    INSERT INTO KhachHang VALUES('0901111114', N'Phạm Thị Dung', 'dung@gmail.com', N'126 Đường D, TP.HCM','123456')
    INSERT INTO KhachHang VALUES('0901111115', N'Hoàng Văn Em', 'em@gmail.com', N'127 Đường E, TP.HCM','123456')
    INSERT INTO KhachHang VALUES('0901111116', N'Vũ Thị Phương', 'phuong@gmail.com', N'128 Đường F, TP.HCM','123456')
    INSERT INTO KhachHang VALUES('0901111117', N'Đặng Văn Giang', 'giang@gmail.com', N'129 Đường G, TP.HCM','123456')
    INSERT INTO KhachHang VALUES('0901111118', N'Bùi Thị Hà', 'ha@gmail.com', N'130 Đường H, TP.HCM','123456')
    INSERT INTO KhachHang VALUES('0901111119', N'Ngô Văn Khoa', 'khoa@gmail.com', N'131 Đường I, TP.HCM','123456')
    INSERT INTO KhachHang VALUES('0901111120', N'Đỗ Thị Lan', 'lan@gmail.com', N'132 Đường J, TP.HCM','123456')
    INSERT INTO KhachHang VALUES('0901111121', N'Mai Văn Minh', 'minh@gmail.com', N'133 Đường K, TP.HCM','123456')
    INSERT INTO KhachHang VALUES('0901111122', N'Lý Thị Ngọc', 'ngoc@gmail.com', N'134 Đường L, TP.HCM','123456')
    INSERT INTO KhachHang VALUES('0901111123', N'Trương Văn Phúc', 'phuc@gmail.com', N'135 Đường M, TP.HCM','123456')
    INSERT INTO KhachHang VALUES('0901111124', N'Vương Thị Quỳnh', 'quynh@gmail.com', N'136 Đường N, TP.HCM','123456')
    INSERT INTO KhachHang VALUES('0901111125', N'Lưu Văn Sơn', 'son@gmail.com', N'137 Đường O, TP.HCM','123456')
    INSERT INTO KhachHang VALUES('0901111126', N'Chu Thị Tuyết', 'tuyet@gmail.com', N'138 Đường P, TP.HCM','123456')
    INSERT INTO KhachHang VALUES('0901111127', N'Đinh Văn Uy', 'uy@gmail.com', N'139 Đường Q, TP.HCM','123456')
    INSERT INTO KhachHang VALUES('0901111128', N'Lâm Thị Vân', 'van@gmail.com', N'140 Đường R, TP.HCM','123456')
    INSERT INTO KhachHang VALUES('0901111129', N'Hồ Văn Xuân', 'xuan@gmail.com', N'141 Đường S, TP.HCM','123456')
    INSERT INTO KhachHang VALUES('0901111130', N'Phan Thị Yến', 'yen@gmail.com', N'142 Đường T, TP.HCM','123456')


    -- Cập nhật bảng TiLe (Đánh giá sản phẩm)
    INSERT INTO TiLe VALUES('CF001', 4)
    INSERT INTO TiLe VALUES('CF002', 5)
    INSERT INTO TiLe VALUES('CF003', 4)
    INSERT INTO TiLe VALUES('CF004', 5)
    INSERT INTO TiLe VALUES('CF005', 3)
    INSERT INTO TiLe VALUES('CF006', 4)
    INSERT INTO TiLe VALUES('CF007', 5)
    INSERT INTO TiLe VALUES('TR001', 4)
    INSERT INTO TiLe VALUES('TR002', 5)
    INSERT INTO TiLe VALUES('TR003', 4)
    INSERT INTO TiLe VALUES('TR004', 5)
    INSERT INTO TiLe VALUES('TR005', 4)
    INSERT INTO TiLe VALUES('TR006', 3)
    INSERT INTO TiLe VALUES('TR007', 5)
    INSERT INTO TiLe VALUES('TR008', 4)
    INSERT INTO TiLe VALUES('TR009', 5)
    INSERT INTO TiLe VALUES('TR010', 4)
    INSERT INTO TiLe VALUES('TR011', 3)
    INSERT INTO TiLe VALUES('TR012', 5)
    INSERT INTO TiLe VALUES('TR013', 4)
    INSERT INTO TiLe VALUES('TR014', 5)
    INSERT INTO TiLe VALUES('DU001', 4)
    INSERT INTO TiLe VALUES('DU002', 5)
    INSERT INTO TiLe VALUES('DU003', 4)
    INSERT INTO TiLe VALUES('DU004', 5)
    INSERT INTO TiLe VALUES('DU005', 4)
    INSERT INTO TiLe VALUES('DU006', 3)
    INSERT INTO TiLe VALUES('DU007', 5)
    INSERT INTO TiLe VALUES('DU008', 4)
    INSERT INTO TiLe VALUES('DU009', 5)
    INSERT INTO TiLe VALUES('DU010', 4)
    INSERT INTO TiLe VALUES('DU011', 3)
    INSERT INTO TiLe VALUES('DU012', 5)
    INSERT INTO TiLe VALUES('DU013', 4)
    INSERT INTO TiLe VALUES('BN001', 4)


    -- Cập nhật bảng BinhLuan (Bình luận sản phẩm)
    INSERT INTO BinhLuan VALUES('CF001', N'Cà phê Robusta rất ngon, đậm đà')
    INSERT INTO BinhLuan VALUES('CF001', N'Vị hơi đắng nhưng hợp khẩu vị')
    INSERT INTO BinhLuan VALUES('CF002', N'Cà phê thơm đậm chuẩn vị')
    INSERT INTO BinhLuan VALUES('CF003', N'Cà phê xúc tác thơm ngon')
    INSERT INTO BinhLuan VALUES('CF004', N'Cà phê thượng hạng đúng điệu')
    INSERT INTO BinhLuan VALUES('CF005', N'Bạc xỉu ngon nhưng ')
    INSERT INTO BinhLuan VALUES('CF006', N'Cà phê đen đúng chất')
    INSERT INTO BinhLuan VALUES('CF007', N'Cà phê sữa ngọt vừa phải')
    INSERT INTO BinhLuan VALUES('TR001', N'Trà đào thanh mát')
    INSERT INTO BinhLuan VALUES('TR002', N'Trà vải ngon tuyệt')
    INSERT INTO BinhLuan VALUES('TR003', N'Trà dưa lưới thơm ngon')
    INSERT INTO BinhLuan VALUES('TR004', N'Trà đào cam sả độc đáo')
    INSERT INTO BinhLuan VALUES('TR005', N'Trà chôm chôm lạ miệng')
    INSERT INTO BinhLuan VALUES('TR006', N'Trà chanh dây chua ngọt')
    INSERT INTO BinhLuan VALUES('TR007', N'Trà kỷ tử táo đỏ bổ dưỡng')
    INSERT INTO BinhLuan VALUES('TR008', N'Trà sữa khúc bạch mềm mịn')
    INSERT INTO BinhLuan VALUES('TR009', N'Trà sữa hạt sen thơm ngon')
    INSERT INTO BinhLuan VALUES('TR010', N'Trà sữa trân châu đường đen')
    INSERT INTO BinhLuan VALUES('TR011', N'Trà sữa khoai môn đậu đỏ')
    INSERT INTO BinhLuan VALUES('TR012', N'Trà oloong phômai')
    INSERT INTO BinhLuan VALUES('TR013', N'Trà la hán quả cam ')
    INSERT INTO BinhLuan VALUES('TR014', N'Trà lài đác thơm ')
    INSERT INTO BinhLuan VALUES('DU001', N'Táo ép tươi ngon')
    INSERT INTO BinhLuan VALUES('DU002', N'Nước ép dưa hấu mát lạnh')
    INSERT INTO BinhLuan VALUES('DU003', N'Nước ép cà rốt tốt cho sức khỏe')
    INSERT INTO BinhLuan VALUES('DU004', N'Nước ép cam giàu vitamin')
    INSERT INTO BinhLuan VALUES('DU005', N'Nước ép ổi thơm ngon')
    INSERT INTO BinhLuan VALUES('DU006', N'Nước ép thơm ngon')
    INSERT INTO BinhLuan VALUES('DU007', N'Sinh tố dâu tươi ngon')
    INSERT INTO BinhLuan VALUES('DU008', N'Sinh tố việt quất bổ dưỡng')
    INSERT INTO BinhLuan VALUES('DU009', N'Tốt')
    INSERT INTO BinhLuan VALUES('DU010', N'Sinh tố bơ dằm hạt đác')
    INSERT INTO BinhLuan VALUES('DU011', N'Sinh tố xoài nhiệt đới')
    INSERT INTO BinhLuan VALUES('DU012', N'Tốt')
    INSERT INTO BinhLuan VALUES('DU013', N'Nước đá chanh mát lạnh')
    INSERT INTO BinhLuan VALUES('BN001', N'Bánh quy sô cô la thơm ngon')


    -- Cập nhật bảng DonDatHang 
    INSERT INTO DonDatHang VALUES('DH001', '0901111111', N'Cho thêm ít đá', '2025-01-02 08:30:00', 'completed')
    INSERT INTO DonDatHang VALUES('DH002', '0901111112', N'Không đường', '2025-01-02 09:15:00', 'completed')
    INSERT INTO DonDatHang VALUES('DH003', '0901111113', N'Cho thêm sữa', '2025-01-02 10:00:00', 'completed')
    INSERT INTO DonDatHang VALUES('DH004', '0901111114', N'Ít đá', '2025-01-02 11:30:00', 'completed')
    INSERT INTO DonDatHang VALUES('DH005', '0901111115', N'Nhiều đường', '2025-01-02 13:45:00', 'completed')
    INSERT INTO DonDatHang VALUES('DH006', '0901111116', N'Để riêng bánh', '2025-01-02 14:20:00', 'completed')
    INSERT INTO DonDatHang VALUES('DH007', '0901111117', N'Cho thêm muối', '2025-01-02 15:10:00', 'completed')
    INSERT INTO DonDatHang VALUES('DH008', '0901111118', N'Ít ngọt', '2025-01-02 16:30:00', 'completed')
    INSERT INTO DonDatHang VALUES('DH009', '0901111119', N'Thêm trân châu', '2025-01-02 17:45:00', 'completed')
    INSERT INTO DonDatHang VALUES('DH010', '0901111120', N'Để nóng', '2025-01-02 18:20:00', 'completed')
    INSERT INTO DonDatHang VALUES('DH011', '0901111121', N'Cho thêm đá', '2025-01-03 08:30:00', 'completed')
    INSERT INTO DonDatHang VALUES('DH012', '0901111122', N'Ít sữa', '2025-01-03 09:15:00', 'completed')
    INSERT INTO DonDatHang VALUES('DH013', '0901111123', N'Thêm kem', '2025-01-03 10:00:00', 'completed')
    INSERT INTO DonDatHang VALUES('DH014', '0901111124', N'Không đá', '2025-01-03 11:30:00', 'completed')
    INSERT INTO DonDatHang VALUES('DH015', '0901111125', N'Nhiều sữa', '2025-01-03 13:45:00', 'completed')
    INSERT INTO DonDatHang VALUES('DH016', '0901111126', N'Để riêng đồ uống', '2025-01-03 14:20:00', 'completed')
    INSERT INTO DonDatHang VALUES('DH017', '0901111127', N'Cho thêm đường', '2025-01-03 15:10:00', 'completed')
    INSERT INTO DonDatHang VALUES('DH018', '0901111128', N'Ít ngọt', '2025-01-03 16:30:00', 'completed')
    INSERT INTO DonDatHang VALUES('DH019', '0901111129', N'Thêm topping', '2025-01-03 17:45:00', 'completed')
    INSERT INTO DonDatHang VALUES('DH020', '0901111130', N'Để lạnh', '2025-01-03 18:20:00', 'completed')
    INSERT INTO DonDatHang VALUES('DH021', '0901111121', N'Cho thêm ít đá', '2025-01-04 08:30:00', 'pending')
    INSERT INTO DonDatHang VALUES('DH022', '0901111122', N'Không đường', '2025-01-04 09:15:00', 'pending')
    INSERT INTO DonDatHang VALUES('DH023', '0901111123', N'Cho thêm sữa', '2025-01-04 10:00:00', 'pending')
    INSERT INTO DonDatHang VALUES('DH024', '0901111124', N'Ít đá', '2025-01-04 11:30:00', 'pending')
    INSERT INTO DonDatHang VALUES('DH025', '0901111125', N'Nhiều đường', '2025-01-04 13:45:00', 'pending')
    INSERT INTO DonDatHang VALUES('DH026', '0901111126', N'Để riêng bánh', '2025-01-04 14:20:00', 'pending')
    INSERT INTO DonDatHang VALUES('DH027', '0901111127', N'Cho thêm muối', '2025-01-04 15:10:00', 'pending')
    INSERT INTO DonDatHang VALUES('DH028', '0901111128', N'Ít ngọt', '2025-01-04 16:30:00', 'pending')
    INSERT INTO DonDatHang VALUES('DH029', '0901111129', N'Thêm trân châu', '2025-01-04 17:45:00', 'pending')
    INSERT INTO DonDatHang VALUES('DH030', '0901111130', N'Để nóng', '2025-01-04 18:20:00', 'pending')


    -- Cập nhật bảng DonDatHangChiTiet (Chi tiết đơn hàng)
    INSERT INTO DonDatHangChiTiet VALUES('DH001', 'CF001', 2, 70000)
    INSERT INTO DonDatHangChiTiet VALUES('DH001', 'BN001', 1, 35000)
    INSERT INTO DonDatHangChiTiet VALUES('DH002', 'CF002', 1, 38000) -- Giảm 5%
    INSERT INTO DonDatHangChiTiet VALUES('DH003', 'CF003', 3, 135000)
    INSERT INTO DonDatHangChiTiet VALUES('DH004', 'TR001', 2, 80000)
    INSERT INTO DonDatHangChiTiet VALUES('DH005', 'TR002', 1, 38000) -- Giảm 5%
    INSERT INTO DonDatHangChiTiet VALUES('DH006', 'BN001', 2, 70000)
    INSERT INTO DonDatHangChiTiet VALUES('DH007', 'DU001', 1, 50000)
    INSERT INTO DonDatHangChiTiet VALUES('DH008', 'DU002', 3, 120000)
    INSERT INTO DonDatHangChiTiet VALUES('DH009', 'TR010', 2, 110000)
    INSERT INTO DonDatHangChiTiet VALUES('DH010', 'CF004', 1, 45000) -- Giảm 10%
    INSERT INTO DonDatHangChiTiet VALUES('DH011', 'CF005', 2, 60000)
    INSERT INTO DonDatHangChiTiet VALUES('DH012', 'BN001', 1, 35000)
    INSERT INTO DonDatHangChiTiet VALUES('DH013', 'DU003', 2, 90000)
    INSERT INTO DonDatHangChiTiet VALUES('DH014', 'TR005', 1, 45000)
    INSERT INTO DonDatHangChiTiet VALUES('DH015', 'CF006', 3, 75000)
    INSERT INTO DonDatHangChiTiet VALUES('DH016', 'BN001', 2, 70000)
    INSERT INTO DonDatHangChiTiet VALUES('DH017', 'DU004', 1, 47500) -- Giảm 5%
    INSERT INTO DonDatHangChiTiet VALUES('DH018', 'TR006', 2, 80000)
    INSERT INTO DonDatHangChiTiet VALUES('DH019', 'CF007', 1, 30000)
    INSERT INTO DonDatHangChiTiet VALUES('DH020', 'BN001', 3, 105000)
    INSERT INTO DonDatHangChiTiet VALUES('DH021', 'DU005', 2, 90000)
    INSERT INTO DonDatHangChiTiet VALUES('DH022', 'TR007', 1, 45000)
    INSERT INTO DonDatHangChiTiet VALUES('DH023', 'CF001', 2, 70000)
    INSERT INTO DonDatHangChiTiet VALUES('DH024', 'BN001', 1, 35000)
    INSERT INTO DonDatHangChiTiet VALUES('DH025', 'DU006', 3, 120000)
    INSERT INTO DonDatHangChiTiet VALUES('DH026', 'TR008', 2, 95000) -- Giảm 5%
    INSERT INTO DonDatHangChiTiet VALUES('DH027', 'CF002', 1, 38000) -- Giảm 5%
    INSERT INTO DonDatHangChiTiet VALUES('DH028', 'BN001', 2, 70000)
    INSERT INTO DonDatHangChiTiet VALUES('DH029', 'DU007', 1, 55000)
    INSERT INTO DonDatHangChiTiet VALUES('DH030', 'TR009', 1, 52250) -- Giảm 5%

