﻿using Project_new.Models;
using System;
using System.Collections.Generic;
using System.Data.Entity.SqlServer;
using System.Linq;
using System.Web.Mvc;

namespace Project_new.Controllers.QuanLy
{
    public class DashBoardController : Controller
    {
        private readonly Project_newEntities db = new Project_newEntities();

        // GET: QuanLy/Dashboard
        public ActionResult Index()
        {
            var totalProducts = db.SanPhams.Count();
            var totalOrders = db.DonDatHangs.Count();
            var totalCustomers = db.KhachHangs.Count();

            // Lấy đơn hàng hoàn thành
            var completedOrderDetails = db.DonDatHangChiTiets
                .Join(db.DonDatHangs,
                    ddhct => ddhct.MaDDH,
                    ddh => ddh.MaDDH,
                    (ddhct, ddh) => new { ddhct, ddh })
                .Where(combined => combined.ddh.TrangThaiDDH == "completed")
                .ToList();

            decimal totalRevenue = completedOrderDetails
                .Sum(combined =>
                {
                    decimal thanhTien;
                    if (decimal.TryParse(combined.ddhct.ThanhTienDDHCT, out thanhTien))
                    {
                        return thanhTien;
                    }
                    return 0;
                });

            var topSellingProducts = db.DonDatHangChiTiets
                .GroupBy(ddhct => ddhct.MaSP)
                .OrderByDescending(g => g.Sum(ddhct => ddhct.SoLuongDDHCT))
                .Take(5)
                .Select(g => new TopSellingProductViewModel
                {
                    MaSP = g.Key,
                    TenSP = db.SanPhams.FirstOrDefault(sp => sp.MaSP == g.Key).TenSP,
                    TongSoLuongBan = g.Sum(ddhct => ddhct.SoLuongDDHCT) ?? 0
                })
                .ToList();

            // Doanh thu theo tháng
            var doanhThuTheoThang = db.DonDatHangs
     .Where(ddh => ddh.TrangThaiDDH == "completed" && ddh.NgayGioDDH != null)
     .GroupBy(ddh => new
     {
         Thang = SqlFunctions.DatePart("month", ddh.NgayGioDDH),
         Nam = SqlFunctions.DatePart("year", ddh.NgayGioDDH)
     })
     .ToList() // Lấy dữ liệu về bộ nhớ
     .Select(g => new DoanhThuTheoThangViewModel
     {
         Thang = g.Key.Thang + "/" + g.Key.Nam,
         TongDoanhThu = g.SelectMany(d => d.DonDatHangChiTiets)
                         .Sum(ct =>
                         {
                             decimal value;
                             return decimal.TryParse(ct.ThanhTienDDHCT, out value) ? value : 0;
                         })
     })
     .OrderBy(x => x.Thang)
     .ToList();




            // ViewModel
            var dashboardViewModel = new DashboardViewModel
            {
                TotalProducts = totalProducts,
                TotalOrders = totalOrders,
                TotalCustomers = totalCustomers,
                TotalRevenue = totalRevenue,
                TopSellingProducts = topSellingProducts,
                DoanhThuTheoThang = doanhThuTheoThang
            };

            return View(dashboardViewModel);
        }


        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}